'
'  This program returns information about VESA support and also about
' whatever VESA mode was specified on the command line.
'
'  Define REGISTERS variable type for interrupt calls and declare
' function.
'
DECLARE FUNCTION BIN$(N AS LONG)
M$=COMMAND$
LM=LEN(M$) : IF RIGHT$(M$,1)="H" THEN LM=LM-1
IF LM>0 THEN M$=MID$(M$,1,LM)
TYPE REGISTERS
AX AS INTEGER
BX AS INTEGER
CX AS INTEGER
DX AS INTEGER
BP AS INTEGER
SI AS INTEGER
DI AS INTEGER
FLAGS AS INTEGER
DS AS INTEGER
ES AS INTEGER
END TYPE
DIM INREGS AS REGISTERS,OUTREGS AS REGISTERS,A(1 TO 64) AS LONG,MDL AS INTEGER
DIM BYTE AS LONG,HR AS INTEGER,VR AS INTEGER,HS AS INTEGER,VS AS INTEGER
DIM PLANES AS INTEGER,PSM AS INTEGER,POFS AS INTEGER
'
'  Use interrupt 10 / function 4F / subfunction 0 to find out if VESA is
' supported by video adapter.  Array A is used to store information from
' interrupt calls.
'
SM=VARSEG(A(1)) : OS=VARPTR(A(1))
INREGS.AX=&H4F00
INREGS.ES=SM
INREGS.DI=OS
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
DEF SEG=SM
T$=CHR$(PEEK(OS))+CHR$(PEEK(OS+1))+CHR$(PEEK(OS+2))+CHR$(PEEK(OS+3))
CLS
IF T$="VESA" THEN
'
'  VESA is supported.  Get rest of information returned by this interrupt
' call.
'
PRINT "Your video system recognizes VESA."
PRINT
'
'  Get VESA version number.
'
VESAFRC=PEEK(OS+4)
FIXFRC:
VESAFRC=VESAFRC/10
IF VESAFRC>=1 THEN GOTO FIXFRC
VESA=PEEK(OS+5)+VESAFRC
'
'  Get OEM string (manufacturer's identity).  (Get pointer to OEM string
' first.)
'
OEMSM=PEEK(OS+8)+256*PEEK(OS+9) : OEMOFF=PEEK(OS+6)+256*PEEK(OS+7)
POFS=PEEK(OS+14)+256*PEEK(OS+15) : PSM=PEEK(OS+16)+256*PEEK(OS+17)
POINTER$=HEX$(PSM)+":"+HEX$(POFS)+"."
DEF SEG=OEMSM
OEM$=""
10 OEM=PEEK(OEMOFF) : OEMOFF=OEMOFF+1
IF OEM<>0 THEN OEM$=OEM$+CHR$(OEM) : GOTO 10
'
'  If video mode was specified on command line, use subfunction 1 (same
' interrupt and function) to return information about it after confirming
' that it's listed as supported.
'
IF LM>0 THEN
MD=VAL("&H"+M$)
M$=M$+"h"
MDL=MD
IF MD<20 THEN GOTO 30
DEF SEG=PSM
20 MDL=PEEK(POFS)+256*PEEK(POFS+1) : POFS=POFS+2
IF MDL<>MD AND MDL<>&HFFFF THEN GOTO 20
30 IF MDL=MD THEN
'
'  Specified mode was found in list.  Get information about it.
'
INREGS.AX=&H4F01
INREGS.CX=MDL
INREGS.ES=SM
INREGS.DI=OS
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
DEF SEG=SM
BYTE=CLNG(PEEK(OS)+256*PEEK(OS+1))
B$=LTRIM$(RTRIM$(BIN$(BYTE)))
N=LEN(B$)
C$=MID$(B$,N,1)
D$=MID$(B$,N-2,1)
IF C$="1" THEN PRINT "Your hardware is compatible with screen mode ";M$;"."
IF C$="0" THEN PRINT "Your hardware does not support screen mode ";M$;"."
PRINT
IF D$="0" THEN PRINT "Your BIOS does not support screen mode ";M$;"."
IF D$="1" THEN PRINT "Your BIOS supports screen mode ";M$;"."
PRINT
IF C$="1" OR D$="1" THEN
E$=MID$(B$,N-4,1)
IF E$="1" THEN PRINT "This is a graphics mode."
IF E$="0" THEN PRINT "This is a text mode."
PRINT
F$=MID$(B$,N-1,1)
IF F$="1" THEN
'
'  The character size (HS x VS), in bytes 22 and 23, is used to correct
' the text mode resolution (HR x VR) incorrectly output by some VESA
' boards.  (HR, in bytes 18 and 19, and VR, in bytes 20 and 21, give the
' horizontal and vertical resolution even for graphics modes.)
'
HS=PEEK(OS+22) : VS=PEEK(OS+23)
PRINT "This mode's character size is ";
PRINT LTRIM$(RTRIM$(STR$(HS)));" x ";LTRIM$(RTRIM$(STR$(VS)));"."
PRINT
HR=PEEK(OS+18)+256*PEEK(OS+19) : VR=PEEK(OS+20)+256*PEEK(OS+21)
COLORS=2!^CSNG(PEEK(OS+25)) : PLANES=PEEK(OS+24)
IF E$="0" THEN
IF VESA<1.2 THEN HR=HR/HS : VR=VR/VS
PRINT "This mode's character resolution and supported colors are ";
ELSE
PRINT "This mode's pixel resolution and supported colors are ";
END IF
IF VESA<1.2 AND ((MD>=0 AND MD<=6) OR MD=13 OR MD=14 OR MD=19) THEN VR=VR/2
PRINT LTRIM$(RTRIM$(STR$(HR)));" x ";LTRIM$(RTRIM$(STR$(VR)));" x ";
PRINT LTRIM$(RTRIM$(STR$(COLORS)));"."
PRINT
PRINT "It has ";LTRIM$(RTRIM$(STR$(PLANES)));" bit planes per pixel and will ";
PRINT "support ";LTRIM$(RTRIM$(STR$(PEEK(OS+29))));" video page(s)."
ELSE
PRINT "No extended information available."
END IF
BYTE=CLNG(PEEK(OS+16)+256*PEEK(OS+17))
PRINT
PRINT "There are ";LTRIM$(RTRIM$(STR$(BYTE)));" bytes per scan line."
PRINT
END IF
ELSE
PRINT "You don't appear to have any type of support for screen mode ";M$"."
PRINT
END IF
END IF
PRINT "Your VESA version number = ";LTRIM$(STR$(VESA))
PRINT
PRINT "Your 'OEM STRING' is '";OEM$;"'."
PRINT
IF PSM>=&HA000 THEN
PRINT "A list of screen modes supported by your system MIGHT be found at ";
PRINT POINTER$
PRINT
END IF
IF LM=0 THEN
'
'  Video mode wasn't specified on command line.
'
PRINT
PRINT "Specify video mode (VS1 hex-mode) for specific mode analysis."
PRINT
END IF
ELSE
'
'  Video adapter does not support VESA (or else interrupt call was lied
' to).
'
PRINT "Your video system is not VESA-aware."
END IF
END
'
'  This is a "functionized" version of code extracted from a more general
' numeric base conversion program by Robert B. Relf, (C) 1984.  This just
' uses the part of Mr. Relf's code that converts decimal to binary.
'
FUNCTION BIN$(NUM AS LONG)
DIM X AS INTEGER
IF NUM<0 THEN NUM=NUM+65536&
BIN1$=""
FOR X=15 TO 0 STEP -1
IF NUM>=(2^X) THEN
BIN1$=BIN1$+"1"
NUM=NUM-(2^X)
ELSE
BIN1$=BIN1$+"0"
END IF
NEXT X
BIN1$=LEFT$(BIN1$,8)+RIGHT$(BIN1$,8)
BIN$=BIN1$
END FUNCTION
